local t = Def.ActorFrame {
	Def.Quad {
		Name="HeaderBase",
		InitCommand=cmd(horizalign,left;vertalign,top;zoomto,_screen.w*1.3,32;diffuse,LocalBlueColor(0.5))
	},
	
	LoadActor(THEME:GetPathG("", "_ScreenEvaluation header")) .. {
		Name="HeaderBase",
		InitCommand=function(self)
			self:vertalign(top):xy(_screen.cx,-2)
		end
	},
	
	LoadFont("Common Normal") .. {
		Name="HeaderText",
		Text=string.upper(Screen.String("HeaderText")),
		InitCommand=cmd(x,_screen.cx;y,2;vertalign,top;shadowlength,2;maxwidth,_screen.w;zoom,0.9),
		OnCommand=cmd(strokecolor,Color.Black),
		UpdateScreenHeaderMessageCommand=function(self,param)
			self:settext(param.Header):uppercase(true)
		end
	},
	
	Def.BitmapText {
		Name = "ModeDisplay",
		Font = "Common Normal",
		Text = CurGameModeString(),
		InitCommand=cmd(xy,(_screen.w/3)*2,8;horizalign,left;vertalign,top;strokecolor,Color.Outline;zoom,0.6;uppercase,true)
	}
}

if not GAMESTATE:IsCourseMode() and not THEME:GetMetric( Var "LoadingScreen","Summary" ) then
	t[#t+1] = Def.BitmapText {
		Name = "StageDisplay",
		Font = "Common Normal",
		InitCommand=cmd(xy,_screen.w/3,8;horizalign,right;vertalign,top;strokecolor,Color.Outline;zoom,0.6;uppercase,true),
		OnCommand=function(self)
			local curStageIndex = GAMESTATE:GetCurrentStageIndex()
			local curStage = GAMESTATE:GetCurrentStage()
			if GAMESTATE:IsEventMode() then
				self:settextf("Stage %s", curStageIndex)
			else
				self:settext(StageToLocalizedString(STATSMAN:GetCurStageStats():GetStage()))
			end
			
			--self:diffuse(StageToColor(STATSMAN:GetCurStageStats():GetStage()))
		end
	}
end

return t